/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_436;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5499;
import net.minecraft.class_5676;
import rikka.lanserverproperties.IPUtils;
import rikka.lanserverproperties.IShareToLanScreenParamAccessor;
import rikka.lanserverproperties.IntegerEditBox;
import rikka.lanserverproperties.OnlineMode;
import rikka.lanserverproperties.Preferences;
import rikka.lanserverproperties.UUIDFixer;

public class OpenToLanScreenEx {
    private static final class_2561 preferenceEnabledLabel = class_2561.method_43471((String)"lanserverproperties.options.preference_enabled");
    private static final class_2561 preferenceEnabledTooltip = class_2561.method_43471((String)"lanserverproperties.options.preference_enabled.message");
    private static final class_2561 preferenceLoadLabel = class_2561.method_43471((String)"lanserverproperties.button.preference_load");
    private static final class_2561 preferenceSaveLabel = class_2561.method_43471((String)"lanserverproperties.button.preference_save");
    private static final class_2561 pvpAllowedLabel = class_2561.method_43471((String)"lanserverproperties.gui.pvp_allowed");
    private static final class_2561 portDescLabel = class_2561.method_43471((String)"lanserverproperties.gui.port");
    private static final class_2561 portListeningLabel = class_2561.method_43471((String)"lanserverproperties.gui.port_listening");
    private static final class_2561 maxPlayerDescLabel = class_2561.method_43471((String)"lanserverproperties.gui.max_player");
    private static final Function<String, Boolean> portValidator = IntegerEditBox.makeValidator(0, 65535);
    private static final Function<String, Boolean> maxPlayerValidator = IntegerEditBox.makeValidator(0, 16);
    private final class_436 screen;
    private final IShareToLanScreenParamAccessor stlParamAccessor;
    private Supplier<Boolean> validateFields = null;
    private Consumer<Boolean> enableOkButton = null;
    private Preferences preferences;
    private boolean pvpAllowed;
    private OnlineMode onlineMode;
    private int port;
    private int maxPlayer;

    public OpenToLanScreenEx(class_436 screen, IShareToLanScreenParamAccessor stlParamAccessor) {
        this.screen = screen;
        this.stlParamAccessor = stlParamAccessor;
        class_1132 server = class_310.method_1551().method_1576();
        if (server.method_3860()) {
            this.preferences = Preferences.read();
            stlParamAccessor.setDefault(server.method_3761(), server.method_3760().method_14579());
            this.onlineMode = OnlineMode.of(server.method_3828(), UUIDFixer.try_online_first);
            this.pvpAllowed = server.method_3852();
            this.port = server.method_3756();
            this.maxPlayer = server.method_3802();
        } else {
            this.readFromPreference(false);
        }
    }

    private void readFromPreference(boolean forceLoad) {
        this.preferences = Preferences.read();
        if (!forceLoad && !this.preferences.enablePreference) {
            this.preferences = new Preferences();
        }
        this.stlParamAccessor.setDefault(this.preferences.gameMode, this.preferences.allowCheat);
        this.onlineMode = OnlineMode.of(this.preferences.onlineMode, this.preferences.fixUUID);
        this.pvpAllowed = this.preferences.allowPVP;
        this.port = this.preferences.defaultPort;
        this.maxPlayer = this.preferences.maxPlayer;
    }

    private void copyToPreference() {
        this.preferences.gameMode = this.stlParamAccessor.getGameType();
        this.preferences.allowCheat = this.stlParamAccessor.isCommandEnabled();
        this.preferences.onlineMode = this.onlineMode.onlineModeEnabled;
        this.preferences.fixUUID = this.onlineMode.tryOnlineUUIDFirst;
        this.preferences.allowPVP = this.pvpAllowed;
        this.preferences.defaultPort = this.port;
        this.preferences.maxPlayer = this.maxPlayer;
    }

    private void applyServerConfig(class_1132 server, boolean setVanillaOptions) {
        if (setVanillaOptions) {
            server.method_3838(this.stlParamAccessor.getGameType());
            server.method_3760().method_14607(this.stlParamAccessor.isCommandEnabled());
        }
        server.method_3864(this.onlineMode.onlineModeEnabled);
        server.method_3815(this.pvpAllowed);
        UUIDFixer.try_online_first = this.onlineMode.tryOnlineUUIDFirst;
        this.stlParamAccessor.setMaxPlayer(this.maxPlayer);
    }

    private static class_4185 findButton(List<? extends class_364> list, String vanillaLangKey) {
        for (class_364 class_3642 : list) {
            class_4185 button;
            class_2561 component;
            if (!(class_3642 instanceof class_4185) || !((component = (button = (class_4185)class_3642).method_25369()).method_10851() instanceof class_2588) || !((class_2588)component.method_10851()).method_11022().equals(vanillaLangKey)) continue;
            return button;
        }
        return null;
    }

    public void postInitShareToLanScreen(class_327 textRenderer, List<? extends class_364> list, Consumer<class_364> widgetAdder, Consumer<class_364> widgetRemover) {
        class_310 mc = class_310.method_1551();
        if (!mc.method_1496()) {
            return;
        }
        class_1132 server = mc.method_1576();
        class_4185 openToLanButton = OpenToLanScreenEx.findButton(list, "lanServer.start");
        if (server.method_3860()) {
            if (openToLanButton != null) {
                widgetRemover.accept((class_364)openToLanButton);
            }
            class_4185 doneButton = new class_4185(this.screen.field_22789 / 2 - 155, this.screen.field_22790 - 28, 150, 20, class_5244.field_24334, btn -> {
                this.applyServerConfig(server, true);
                class_310.method_1551().method_1507(this.stlParamAccessor.getLastScreen());
            });
            widgetAdder.accept((class_364)doneButton);
            this.enableOkButton = enabled -> {
                doneButton.field_22763 = enabled;
            };
        } else {
            this.enableOkButton = enabled -> {
                openToLanButton.field_22763 = enabled;
            };
        }
        widgetAdder.accept((class_364)new class_344(this.screen.field_22789 / 2 - 180, 16, 20, 20, 0, 0, 20, new class_2960("textures/gui/accessibility.png"), 32, 64, btn -> {
            this.readFromPreference(true);
            this.screen.method_25423(mc, this.screen.field_22789, this.screen.field_22790);
        }, (btn, poseStack, x, y) -> this.screen.method_25417(poseStack, textRenderer.method_1728((class_5348)preferenceLoadLabel, 200), x, y), preferenceLoadLabel));
        class_4185 preferenceButton = new class_4185(this.screen.field_22789 / 2 - 155, 16, 150, 20, preferenceSaveLabel, btn -> {
            this.copyToPreference();
            this.preferences.save();
        });
        widgetAdder.accept((class_364)preferenceButton);
        widgetAdder.accept((class_364)class_5676.method_32613((boolean)this.preferences.enablePreference).method_32618(curState -> textRenderer.method_1728((class_5348)preferenceEnabledTooltip, 200)).method_32617(this.screen.field_22789 / 2 + 5, 16, 150, 20, preferenceEnabledLabel, (dummyButton, newVal) -> {
            this.preferences.enablePreference = newVal;
        }));
        widgetAdder.accept((class_364)new class_5676.class_5677(state -> state.stateName).method_32624((Object[])OnlineMode.values()).method_32619((Object)this.onlineMode).method_32618(curState -> textRenderer.method_1728((class_5348)curState.tooltip, 200)).method_32616().method_32617(this.screen.field_22789 / 2 - 155, 124, 150, 20, OnlineMode.translation, (dummyButton, newVal) -> {
            this.onlineMode = newVal;
        }));
        widgetAdder.accept((class_364)class_5676.method_32613((boolean)this.pvpAllowed).method_32617(this.screen.field_22789 / 2 + 5, 124, 150, 20, pvpAllowedLabel, (dummyButton, newVal) -> {
            this.pvpAllowed = newVal;
        }));
        IntegerEditBox portEditBox = new IntegerEditBox(textRenderer, this.screen.field_22789 / 2 - 154, this.screen.field_22790 - 54, 147, 20, portDescLabel, this.port, ieb -> {
            boolean enableButtons;
            preferenceButton.field_22763 = enableButtons = this.validateFields.get().booleanValue();
            this.enableOkButton.accept(enableButtons);
            if (ieb.isContentValid()) {
                this.port = ieb.getValueAsInt();
            }
        }, portValidator, ieb -> server.method_3860() ? textRenderer.method_1728((class_5348)class_2561.method_43470((String)IPUtils.getIPs()), 250) : null);
        widgetAdder.accept((class_364)portEditBox);
        if (server.method_3860()) {
            portEditBox.method_1888(false);
        }
        IntegerEditBox portMaxPlayer = new IntegerEditBox(textRenderer, this.screen.field_22789 / 2 + 5, this.screen.field_22790 - 54, 147, 20, maxPlayerDescLabel, this.maxPlayer, ieb -> {
            boolean enableButtons;
            preferenceButton.field_22763 = enableButtons = this.validateFields.get().booleanValue();
            this.enableOkButton.accept(enableButtons);
            if (ieb.isContentValid()) {
                this.maxPlayer = ieb.getValueAsInt();
            }
        }, maxPlayerValidator, null);
        widgetAdder.accept((class_364)portMaxPlayer);
        this.validateFields = () -> portEditBox.isContentValid() && portMaxPlayer.isContentValid();
    }

    public static void initPauseScreen(class_437 gui, List<? extends class_364> list) {
        class_4185 shareToLanButton = OpenToLanScreenEx.findButton(list, "menu.shareToLan");
        if (shareToLanButton != null) {
            shareToLanButton.field_22763 = class_310.method_1551().method_1496();
        }
    }

    public static void postDraw(class_437 gui, class_327 textRenderer, class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        Optional mouserOverControl;
        class_310 mc = class_310.method_1551();
        if (mc.method_1496()) {
            class_1132 server = mc.method_1576();
            if (server.method_3860()) {
                class_437.method_27535((class_4587)matrixStack, (class_327)textRenderer, (class_2561)portListeningLabel, (int)(gui.field_22789 / 2 - 155), (int)(gui.field_22790 - 66), (int)0xA0A0A0);
            } else {
                class_437.method_27535((class_4587)matrixStack, (class_327)textRenderer, (class_2561)portDescLabel, (int)(gui.field_22789 / 2 - 155), (int)(gui.field_22790 - 66), (int)0xA0A0A0);
            }
            class_437.method_27535((class_4587)matrixStack, (class_327)textRenderer, (class_2561)maxPlayerDescLabel, (int)(gui.field_22789 / 2 + 5), (int)(gui.field_22790 - 66), (int)0xA0A0A0);
        }
        if ((mouserOverControl = gui.method_19355((double)mouseX, (double)mouseY)).isPresent() && mouserOverControl.get() instanceof class_5499) {
            List tooltips = ((class_5499)mouserOverControl.get()).method_31047();
            gui.method_25417(matrixStack, tooltips, mouseX, mouseY);
        }
    }

    public int getServerPort() {
        return this.port;
    }

    public void onOpenToLanClosed() {
        class_1132 server = class_310.method_1551().method_1576();
        this.applyServerConfig(server, false);
    }
}

